#include <Windows.h>
#include <Shlobj.h>
#include <stdio.h>
#include <map>

using namespace std;

extern "C"
{
	typedef HRESULT (__stdcall *DllCanUnloadNowType)(void);
	static DllCanUnloadNowType DllCanUnloadNowPtr;
	typedef HRESULT (__stdcall *DllGetClassObjectType)(void);
	static DllGetClassObjectType DllGetClassObjectPtr;
	typedef HRESULT (__stdcall *DllRegisterServerType)(void);
	static DllRegisterServerType DllRegisterServerPtr;
	typedef HRESULT (__stdcall *DllUnregisterServerType)(void);
	static DllUnregisterServerType DllUnregisterServerPtr;
	typedef int *(__cdecl *nvapi_QueryInterfaceType)(unsigned int offset);
	static nvapi_QueryInterfaceType nvapi_QueryInterfacePtr;

	typedef int (__cdecl *NvAPI_Stereo_GetConvergence)(void *stereoHandle, float *pConvergence);
	static NvAPI_Stereo_GetConvergence NvAPI_Stereo_GetConvergencePtr;
	typedef int (__cdecl *NvAPI_Stereo_SetConvergence)(void *stereoHandle, float newConvergence);
	static NvAPI_Stereo_SetConvergence NvAPI_Stereo_SetConvergencePtr;
	typedef int (__cdecl *NvAPI_Stereo_GetSeparation)(void *stereoHandle, float *pSeparationPercentage);
	static NvAPI_Stereo_GetSeparation NvAPI_Stereo_GetSeparationPtr;
	typedef int (__cdecl *NvAPI_Stereo_SetSeparation)(void *stereoHandle, float newSeparationPercentage);
	static NvAPI_Stereo_SetSeparation NvAPI_Stereo_SetSeparationPtr;
}

static HMODULE nvDLL = 0;
static float UserConvergence;
static float UserSeparation;
static map<float, float> GameConvergenceMap, GameConvergenceMapInv;
static FILE *LogConvergenceFile = 0;
static FILE *LogSeparationFile = 0;

static void loadDll()
{
	if (!nvDLL)
	{
		wchar_t sysDir[MAX_PATH];
		SHGetFolderPath(0, CSIDL_SYSTEM, 0, SHGFP_TYPE_CURRENT, sysDir);
		wcscat(sysDir, L"\\nvapi.dll");
		nvDLL = LoadLibrary(sysDir);
		DllCanUnloadNowPtr = (DllCanUnloadNowType)GetProcAddress(nvDLL, "DllCanUnloadNow");
		DllGetClassObjectPtr = (DllGetClassObjectType)GetProcAddress(nvDLL, "DllGetClassObject");
		DllRegisterServerPtr = (DllRegisterServerType)GetProcAddress(nvDLL, "DllRegisterServer");
		DllUnregisterServerPtr = (DllUnregisterServerType)GetProcAddress(nvDLL, "DllUnregisterServer");
		nvapi_QueryInterfacePtr = (nvapi_QueryInterfaceType)GetProcAddress(nvDLL, "nvapi_QueryInterface");
		_wgetcwd(sysDir, MAX_PATH);
		wcscat(sysDir, L"\\nvapi.ini");
		for (int i = 1;; ++i)
		{
			wchar_t id[] = L"Mapxxx", val[MAX_PATH];
			_itow(i, id+3, 10);
			int read = GetPrivateProfileString(L"ConvergenceMap", id, 0, val, MAX_PATH, sysDir);
			if (!read) break;
			unsigned int fromHx;
			float from, to;
			swscanf(val, L"from %x to %e", &fromHx, &to);
			from = *reinterpret_cast<float *>(&fromHx);
			GameConvergenceMap[from] = to;
			GameConvergenceMapInv[to] = from;
		}
		LogConvergenceFile = GetPrivateProfileInt(L"Logging", L"Convergence", 0, sysDir) ? (FILE *)-1 : 0;
		LogSeparationFile = GetPrivateProfileInt(L"Logging", L"Separation", 0, sysDir) ? (FILE *)-1 : 0;
	}
}

STDAPI DllCanUnloadNow(void)
{
	loadDll();
	return (*DllCanUnloadNowPtr)();
}
STDAPI DllGetClassObject(
  __in   REFCLSID rclsid,
  __in   REFIID riid,
  __out  LPVOID *ppv
)
{
	loadDll();
	return (*DllGetClassObjectPtr)();
}
STDAPI DllRegisterServer(void)
{
	loadDll();
	return (*DllRegisterServerPtr)();
}
STDAPI DllUnregisterServer(void)
{
	loadDll();
	return (*DllUnregisterServerPtr)();
}
static int __cdecl NvAPI_Stereo_GetConvergenceEx(void *stereoHandle, float *pConvergence)
{
	int ret = (*NvAPI_Stereo_GetConvergencePtr)(stereoHandle, pConvergence);
	if (LogConvergenceFile)
	{
		if (LogConvergenceFile == (FILE*)-1) LogConvergenceFile = fopen("nvapi_convergencelog.txt", "w");
		fprintf(LogConvergenceFile, "GetConvergence value=%e, hex=%x\n", *pConvergence, *reinterpret_cast<unsigned int *>(pConvergence));
	}
	return ret;
}
static int __cdecl NvAPI_Stereo_SetConvergenceEx(void *stereoHandle, float newConvergence)
{
	if (LogConvergenceFile)
	{
		if (LogConvergenceFile == (FILE*)-1) LogConvergenceFile = fopen("nvapi_convergencelog.txt", "w");
		fprintf(LogConvergenceFile, "SetConvergence to %e, hex=%x\n", newConvergence, *reinterpret_cast<unsigned int *>(&newConvergence));
	}
	// Save current user convergence value.
	float currentConvergence;
	NvAPI_Stereo_GetConvergencePtr = (NvAPI_Stereo_GetConvergence)(*nvapi_QueryInterfacePtr)(0x4ab00934);
	(*NvAPI_Stereo_GetConvergencePtr)(stereoHandle, &currentConvergence);
	if (GameConvergenceMapInv.find(currentConvergence) == GameConvergenceMapInv.end()) UserConvergence = currentConvergence;
	// Map special convergence value?
	map<float, float>::iterator i = GameConvergenceMap.find(newConvergence);
	if (i != GameConvergenceMap.end())
		newConvergence = i->second;
	else
		// Normal convergence value. Replace with user value.
		newConvergence = UserConvergence;	
	// Update needed?
	if (currentConvergence == newConvergence) 
		return 0;
	return (*NvAPI_Stereo_SetConvergencePtr)(stereoHandle, newConvergence);
}
static int __cdecl NvAPI_Stereo_GetSeparationEx(void *stereoHandle, float *pSeparationPercentage)
{
	int ret = (*NvAPI_Stereo_GetSeparationPtr)(stereoHandle, pSeparationPercentage);
	if (LogSeparationFile)
	{
		if (LogSeparationFile == (FILE*)-1) LogSeparationFile = fopen("nvapi_separationlog.txt", "w");
		fprintf(LogSeparationFile, "GetSeparation value=%e, hex=%x\n", *pSeparationPercentage, *reinterpret_cast<unsigned int *>(pSeparationPercentage));
	}
	return ret;
}
static int __cdecl NvAPI_Stereo_SetSeparationEx(void *stereoHandle, float newSeparationPercentage)
{
	int ret = (*NvAPI_Stereo_SetSeparationPtr)(stereoHandle, newSeparationPercentage);
	if (LogSeparationFile)
	{
		if (LogSeparationFile == (FILE*)-1) LogSeparationFile = fopen("nvapi_separationlog.txt", "w");
		fprintf(LogSeparationFile, "SetSeparation value=%e, hex=%x\n", newSeparationPercentage, *reinterpret_cast<unsigned int *>(&newSeparationPercentage));
	}
	return ret;
}
extern "C" __declspec(dllexport) int * __cdecl nvapi_QueryInterface(unsigned int offset)
{
	loadDll();
	int *ptr = (*nvapi_QueryInterfacePtr)(offset);
	switch (offset)
	{
		case 0x4ab00934:
			NvAPI_Stereo_GetConvergencePtr = (NvAPI_Stereo_GetConvergence)ptr;
			ptr = (int *)(NvAPI_Stereo_GetConvergenceEx);
			break;
		case 0x3dd6b54b:
			NvAPI_Stereo_SetConvergencePtr = (NvAPI_Stereo_SetConvergence)ptr;
			ptr = (int *)(NvAPI_Stereo_SetConvergenceEx);
			break;
		case 0x451f2134: 
			NvAPI_Stereo_GetSeparationPtr = (NvAPI_Stereo_GetSeparation)ptr;
			ptr = (int *)(NvAPI_Stereo_GetSeparationEx);
			break;
		case 0x5c069fa3: 
			NvAPI_Stereo_SetSeparationPtr = (NvAPI_Stereo_SetSeparation)ptr;
			ptr = (int *)(NvAPI_Stereo_SetSeparationEx);
			break;
	}
	return ptr;
}
